/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.xmlreport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.param.InvalidCommandlineException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CVXMLReportReader {
    protected String m_xmlFile;
    protected String m_xmlXsdURI = null;
    protected BufferedInputStream m_is = null;
    private HashMap<String, HashMap<String, String>> m_targetList = null;
    private ReportUtilConstants.BasicClusterWareDetails m_header = null;
    protected static MessageBundle s_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    SAXParser saxParser = null;

    public CVXMLReportReader(String xmlFile) throws XmlReportToolException {
        this.m_xmlFile = xmlFile;
        try {
            this.m_xmlXsdURI = ReportUtilConstants.getCVUXmlReportSchemaURI();
        }
        catch (XmlFilePathException e) {
            throw new XmlReportToolException(e);
        }
    }

    public HashMap<String, HashMap<String, String>> getTargetList() throws XmlReportToolException {
        if (this.m_targetList != null) {
            return this.m_targetList;
        }
        HeaderAndTargetListHandler handler = new HeaderAndTargetListHandler();
        this.parse(handler);
        return this.m_targetList;
    }

    public HashMap<String, String> getAttributes(Attributes attributes) {
        HashMap<String, String> attributesHM = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            attributesHM.put(attributes.getQName(i), attributes.getValue(i));
        }
        return attributesHM;
    }

    public String getTargetKey(String targetName, Attributes attributes) {
        String targetKey = "";
        for (int i = 0; i < attributes.getLength(); ++i) {
            targetKey = targetKey + attributes.getValue(i);
        }
        return targetKey;
    }

    private void parse(DefaultHandler handler) throws XmlReportToolException {
        try {
            if (this.saxParser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(true);
                this.saxParser = factory.newSAXParser();
                if (new File(this.m_xmlXsdURI).exists()) {
                    this.saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.m_xmlXsdURI);
                }
            }
            this.saxParser.parse((InputStream)new BufferedInputStream(new FileInputStream(new File(this.m_xmlFile))), handler);
        }
        catch (FileNotFoundException e) {
            throw new XmlReportToolException(s_prvgMsgBundle.getMessage("7500", true, (Object[])new String[]{this.m_xmlFile}), e);
        }
        catch (SAXException e) {
            throw new XmlReportToolException(s_prvgMsgBundle.getMessage("7501", true, (Object[])new String[]{this.m_xmlFile}), e);
        }
        catch (IOException e) {
            throw new XmlReportToolException(s_prvgMsgBundle.getMessage("7503", true, (Object[])new String[]{this.m_xmlFile}), e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlReportToolException(s_prvgMsgBundle.getMessage("7504", true, (Object[])new String[]{this.m_xmlFile}), e);
        }
    }

    public ReportUtilConstants.BasicClusterWareDetails getHeader() throws XmlReportToolException {
        if (this.m_header != null) {
            return this.m_header;
        }
        HeaderAndTargetListHandler handler = new HeaderAndTargetListHandler();
        this.parse(handler);
        return this.m_header;
    }

    public List<Task> getTaskList(final String targetKey) throws XmlReportToolException {
        final ArrayList<Task> taskList = new ArrayList<Task>();
        DefaultHandler handler = new DefaultHandler(){
            boolean targetMatch = false;
            boolean elementName = false;
            boolean elementDesc = false;
            boolean moreDetails = false;
            boolean moreDetailsText = false;
            boolean reference = false;
            boolean nodeResult = false;
            boolean expectedValue = false;
            boolean availableValue = false;
            boolean nodeCollectionSet = false;
            boolean globalErrorDescList = false;
            boolean nodeResultSet = false;
            private boolean msgTxt;
            private boolean cause;
            private boolean action;
            Task task = null;
            CollectionElement collectionElement = null;
            ErrorDescription errDesc = null;
            Result result = null;
            ResultSet resultSet = null;
            private boolean summary;
            private boolean globalCollectionSet;
            private List<String> referenceList = null;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equalsIgnoreCase("TARGET_DATA")) {
                    String targetName = attributes.getValue("ID");
                    if (targetKey.equals(CVXMLReportReader.this.getTargetKey(targetName, attributes))) {
                        this.targetMatch = true;
                    }
                    return;
                }
                if (!this.targetMatch) {
                    return;
                }
                if (qName.equalsIgnoreCase("TASK")) {
                    final String type = attributes.getValue("TYPE");
                    String severity = attributes.getValue("SEVERITY");
                    String overallStatus = attributes.getValue("OVER_ALL_STATUS");
                    this.task = new Task(){
                        protected boolean m_bestPractice;
                        {
                            this.m_bestPractice = ReportUtilConstants.TaskType.RECCOMENDED_TASK.name().equals(type);
                        }

                        @Override
                        public String getDefaultElementName() {
                            return null;
                        }

                        @Override
                        public String getDefaultDescription() {
                            return null;
                        }
                    };
                    this.task.setSeverity(CVXMLReportReader.this.getSeverityAttributeValue(severity));
                    this.task.getResultSet().setStatus(CVXMLReportReader.this.getOverallStatus(overallStatus));
                    taskList.add(this.task);
                }
                if (qName.equalsIgnoreCase("ELEMENT")) {
                    this.elementName = true;
                }
                if (qName.equalsIgnoreCase("DESC")) {
                    this.elementDesc = true;
                }
                if (qName.equalsIgnoreCase("MORE_DETAILS")) {
                    this.moreDetails = true;
                }
                if (qName.equalsIgnoreCase("TEXT") && this.moreDetails) {
                    this.moreDetailsText = true;
                }
                if (qName.equalsIgnoreCase("REFERENCE") && this.moreDetails) {
                    this.reference = true;
                    if (this.referenceList == null) {
                        this.referenceList = new ArrayList<String>();
                        this.task.setReferences(this.referenceList);
                    }
                }
                if (qName.equalsIgnoreCase("GLOBAL_ERROR_DESC_LIST")) {
                    this.globalErrorDescList = true;
                }
                if (qName.equalsIgnoreCase("NODE_RESULT_SET")) {
                    this.nodeResultSet = true;
                }
                if (qName.equalsIgnoreCase("NODE_RESULT") && this.nodeResultSet) {
                    String nodeName = attributes.getValue("NAME");
                    String status = attributes.getValue("STATUS");
                    String fixupAvailable = attributes.getValue("FIXUP_AVAILABLE");
                    this.result = new Result(nodeName);
                    this.result.setStatus(CVXMLReportReader.this.getStatus(status));
                    this.result.setFixupAvailable(Boolean.parseBoolean(fixupAvailable));
                    this.task.getResultSet().addResult(nodeName, this.result);
                }
                if (qName.equalsIgnoreCase("EXPECTED_VALUE")) {
                    this.expectedValue = true;
                }
                if (qName.equalsIgnoreCase("ACTUAL_VALUE")) {
                    this.availableValue = true;
                }
                if (qName.equalsIgnoreCase("ERROR_DESC")) {
                    this.errDesc = new ErrorDescription();
                    if (this.collectionElement != null) {
                        this.collectionElement.addErrorDescription(this.errDesc);
                    }
                    if (this.globalErrorDescList) {
                        this.task.getResultSet().addErrorDescription(this.errDesc);
                    }
                    if (this.nodeResult) {
                        this.result.addErrorDescription(this.errDesc);
                    }
                }
                if (qName.equalsIgnoreCase("MSG_TXT")) {
                    this.msgTxt = true;
                }
                if (qName.equalsIgnoreCase("CAUSE")) {
                    this.cause = true;
                }
                if (qName.equalsIgnoreCase("ACTION")) {
                    this.action = true;
                }
                if (qName.equalsIgnoreCase("TASK_SUMMARY")) {
                    this.summary = true;
                }
                if (qName.equalsIgnoreCase("GLOBAL_COLLECTION_SET")) {
                    this.globalCollectionSet = true;
                }
                if (qName.equalsIgnoreCase("NODE_COLLECTION_SET")) {
                    this.nodeCollectionSet = true;
                }
                if (qName.equalsIgnoreCase("COLLECTION_ELEMENT")) {
                    String name = attributes.getValue("NAME");
                    String node = attributes.getValue("NODE");
                    String desc = attributes.getValue("DESCRIPTION");
                    String status = attributes.getValue("STATUS");
                    this.collectionElement = new CollectionElement(name, node, null, null, null, desc, status);
                    if (this.nodeCollectionSet) {
                        this.task.getResultSet().addCollectionElement(node, this.collectionElement);
                    }
                    if (this.globalCollectionSet) {
                        this.task.getResultSet().addCollectionElement(this.collectionElement);
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equalsIgnoreCase("TARGET_DATA")) {
                    this.targetMatch = false;
                }
                if (qName.equalsIgnoreCase("TASK")) {
                    this.task = null;
                }
                if (qName.equalsIgnoreCase("ELEMENT")) {
                    this.elementName = false;
                }
                if (qName.equalsIgnoreCase("DESC")) {
                    this.elementDesc = false;
                }
                if (qName.equalsIgnoreCase("MORE_DETAILS")) {
                    this.moreDetails = false;
                    this.referenceList = null;
                }
                if (qName.equalsIgnoreCase("TEXT") && this.moreDetails) {
                    this.moreDetailsText = false;
                }
                if (qName.equalsIgnoreCase("REFERENCE") && this.moreDetails) {
                    this.reference = false;
                }
                if (qName.equalsIgnoreCase("GLOBAL_ERROR_DESC_LIST")) {
                    this.globalErrorDescList = false;
                }
                if (qName.equalsIgnoreCase("NODE_RESULT_SET")) {
                    this.nodeResultSet = false;
                }
                if (qName.equalsIgnoreCase("NODE_RESULT") && this.nodeResultSet) {
                    this.result = null;
                }
                if (qName.equalsIgnoreCase("EXPECTED_VALUE")) {
                    this.expectedValue = false;
                }
                if (qName.equalsIgnoreCase("ACTUAL_VALUE")) {
                    this.availableValue = false;
                }
                if (qName.equalsIgnoreCase("ERROR_DESC")) {
                    this.errDesc = new ErrorDescription();
                }
                if (qName.equalsIgnoreCase("MSG_TXT")) {
                    this.msgTxt = false;
                }
                if (qName.equalsIgnoreCase("CAUSE")) {
                    this.cause = false;
                }
                if (qName.equalsIgnoreCase("ACTION")) {
                    this.action = false;
                }
                if (qName.equalsIgnoreCase("TASK_SUMMARY")) {
                    this.summary = false;
                }
                if (qName.equalsIgnoreCase("GLOBAL_COLLECTION_SET")) {
                    this.globalCollectionSet = false;
                }
                if (qName.equalsIgnoreCase("NODE_COLLECTION_SET")) {
                    this.nodeCollectionSet = false;
                }
                if (qName.equalsIgnoreCase("COLLECTION_ELEMENT")) {
                    this.collectionElement = null;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.elementName) {
                    this.task.setElementName(new String(ch, start, length));
                }
                if (this.elementDesc) {
                    this.task.setDescription(new String(ch, start, length));
                }
                if (this.moreDetailsText && this.moreDetails) {
                    this.task.setMoreDetails(new String(ch, start, length));
                }
                if (this.reference && this.moreDetails) {
                    this.referenceList.add(new String(ch, start, length));
                }
                if (this.expectedValue) {
                    if (this.collectionElement != null) {
                        this.collectionElement.setExpectedValue(new String(ch, start, length));
                    }
                    if (this.result != null) {
                        this.result.setHasResultValues(true);
                        this.result.setExpectedValue(new String(ch, start, length));
                    }
                }
                if (this.availableValue) {
                    if (this.collectionElement != null) {
                        this.collectionElement.setValue(new String(ch, start, length));
                    }
                    if (this.result != null) {
                        this.result.setHasResultValues(true);
                        this.result.setActualValue(new String(ch, start, length));
                    }
                }
                if (this.msgTxt) {
                    this.errDesc.setErrorMessage(new String(ch, start, length));
                }
                if (this.cause) {
                    this.errDesc.setCause(new String(ch, start, length));
                }
                if (this.action) {
                    this.errDesc.setAction(new String(ch, start, length));
                }
                if (this.summary) {
                    this.task.getResultSet().setResultSummary(new String(ch, start, length));
                }
            }
        };
        this.parse(handler);
        return taskList;
    }

    private SeverityType getSeverityAttributeValue(String severityStr) {
        SeverityType severity = SeverityType.CRITICAL;
        if ("IGNORABLE".equalsIgnoreCase(severityStr)) {
            severity = SeverityType.IGNORABLE;
        }
        return severity;
    }

    private int getOverallStatus(String status) {
        if (status.equals("SUCCESSFUL")) {
            return 1;
        }
        if (status.equals("OPERATION_FAILED")) {
            return 2;
        }
        if (status.equals("VERIFICATION_FAILED")) {
            return 3;
        }
        if (status.equals("WARNING")) {
            return 4;
        }
        return 5;
    }

    private int getStatus(String status) {
        if (status.contains("SUCCESSFUL")) {
            return 1;
        }
        if (status.contains("OPERATION_FAILED")) {
            return 2;
        }
        if (status.contains("VERIFICATION_FAILED")) {
            return 3;
        }
        if (status.contains("VERIFICATION_WARNING")) {
            return 4;
        }
        if (status.contains("NOT_APPLICABLE")) {
            return 6;
        }
        return 5;
    }

    public static void main(String[] args) {
        String xmlFile = "/scratch/nvira/tmp/cvucheckreport_8142012142220.xml";
        try {
            ParamManager pm = ParamManager.getInstance(ParamManager.OperationMode.MODE_API, null);
            NodeManager nm = NodeManagerFactory.getInstance().getNodeManager(new String[0]);
            CVXMLReportReader reader = new CVXMLReportReader(xmlFile);
            ReportUtilConstants.BasicClusterWareDetails header = reader.getHeader();
            header = reader.getHeader();
            header = reader.getHeader();
            header = reader.getHeader();
            header = reader.getHeader();
            header = reader.getHeader();
            header = reader.getHeader();
            header = reader.getHeader();
            header = reader.getHeader();
            header = reader.getHeader();
            HashMap<String, HashMap<String, String>> targetList = reader.getTargetList();
            List<Task> taskList = null;
            for (String targetName : targetList.keySet()) {
                HashMap<String, String> targetAttributes = targetList.get(targetName);
                taskList = reader.getTaskList(targetName);
                System.out.println("taskList: " + taskList);
            }
        }
        catch (XmlReportToolException e) {
            e.printStackTrace();
        }
        catch (InvalidCommandlineException e) {
            e.printStackTrace();
        }
        catch (NodeManagerFactoryException e) {
            e.printStackTrace();
        }
    }

    class HeaderAndTargetListHandler
    extends DefaultHandler {
        boolean headerStart = false;

        HeaderAndTargetListHandler() {
            CVXMLReportReader.this.m_targetList = new LinkedHashMap();
            CVXMLReportReader.this.m_header = new ReportUtilConstants.BasicClusterWareDetails();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("HEADER")) {
                this.headerStart = true;
                return;
            }
            if (qName.equalsIgnoreCase("TARGET_DATA")) {
                String targetName = attributes.getValue("ID");
                CVXMLReportReader.this.m_targetList.put(CVXMLReportReader.this.getTargetKey(targetName, attributes), CVXMLReportReader.this.getAttributes(attributes));
            }
            if (this.headerStart && qName.equalsIgnoreCase("TIME_STAMP")) {
                String year = attributes.getValue("YEAR");
                String month = attributes.getValue("MONTH");
                String day = attributes.getValue("DAY");
                CVXMLReportReader.this.m_header.getTimeStamp().set(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
                String hours = attributes.getValue("HOURS");
                String minutes = attributes.getValue("MINUTES");
                String seconds = attributes.getValue("SECONDS");
                CVXMLReportReader.this.m_header.getTimeStamp().set(10, Integer.parseInt(hours));
                CVXMLReportReader.this.m_header.getTimeStamp().set(12, Integer.parseInt(minutes));
                CVXMLReportReader.this.m_header.getTimeStamp().set(13, Integer.parseInt(seconds));
            }
            if (this.headerStart && qName.equalsIgnoreCase("CLUSTER_DETAILS")) {
                CVXMLReportReader.this.m_header.setClusterName(attributes.getValue("CLUSTER_NAME"));
                CVXMLReportReader.this.m_header.setClusterwareVersion(attributes.getValue("CLUSTERWARE_VERSION"));
                CVXMLReportReader.this.m_header.setCrsHome(attributes.getValue("CRS_HOME"));
                CVXMLReportReader.this.m_header.setCrsUserName(attributes.getValue("CRS_USER"));
                CVXMLReportReader.this.m_header.setOsPlatform(attributes.getValue("OS_PLATFORM"));
            }
            if (this.headerStart && qName.equalsIgnoreCase("DATABASE")) {
                CVXMLReportReader.this.m_header.addDatabaseDetails(attributes.getValue("NAME"), attributes.getValue("DATABASE_HOME"), attributes.getValue("DATABASE_VERSION"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("HEADER")) {
                this.headerStart = false;
            }
        }
    }
}

